/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetConfig
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetConfig.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element a = request.getElement("a");
        String name = a.getAttribute("n");
        Config config = prov.getConfig();
        AdminAccessControl aac = this.checkRight(zsc, context, config, AdminRight.PR_ALWAYS_ALLOW);
        String[] value = config.getMultiAttr(name);
        Element response = zsc.createElement(AdminConstants.GET_CONFIG_RESPONSE);
        AttributeManager attrMgr = AttributeManager.getInstance();
        AttributeManager.IDNType idnType = AttributeManager.idnType(attrMgr, name);
        boolean allowed = aac.getAttrRightChecker(config).allowAttr(name);
        for (int i = 0; i < value.length; ++i) {
            ToXML.encodeAttr(response, name, value[i], "a", "n", idnType, allowed);
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Need get attr right for the specified attribute.");
    }
}

