/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCalendarResource
extends AdminDocumentHandler {
    private static final String[] TARGET_RESOURCE_PATH = new String[]{"calresource"};

    @Override
    protected String[] getProxiedResourceElementPath() {
        return TARGET_RESOURCE_PATH;
    }

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetCalendarResource.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        boolean applyCos = request.getAttributeBool("applyCos", true);
        Set<String> reqAttrs = this.getReqAttrs(request, AttributeClass.calendarResource);
        Element cr = request.getElement("calresource");
        String key = cr.getAttribute("by");
        String value = cr.getText();
        CalendarResource resource = prov.get(Provisioning.CalendarResourceBy.fromString(key), value);
        if (resource == null) {
            throw AccountServiceException.NO_SUCH_CALENDAR_RESOURCE(value);
        }
        AdminAccessControl aac = this.checkCalendarResourceRight(zsc, resource, AdminRight.PR_ALWAYS_ALLOW);
        Element response = zsc.createElement(AdminConstants.GET_CALENDAR_RESOURCE_RESPONSE);
        ToXML.encodeCalendarResource(response, resource, applyCos, reqAttrs, aac.getAttrRightChecker(resource));
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getCalendarResource);
        notes.add(String.format("Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.To allow an admin to get all attributes, grant the %s right", Rights.Admin.R_getCalendarResource.getName()));
    }
}

