/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.GetZimlet;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAllZimlets
extends AdminDocumentHandler {
    @Override
    public boolean domainAuthSufficient(Map<String, Object> context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String exclude = request.getAttribute("exclude", "none");
        ZimbraSoapContext zsc = GetAllZimlets.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        List<Zimlet> zimlets = prov.listAllZimlets();
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        Element response = zsc.createElement(AdminConstants.GET_ALL_ZIMLETS_RESPONSE);
        if ("extension".equalsIgnoreCase(exclude)) {
            for (Zimlet zimlet : zimlets) {
                if (zimlet.isExtension() || !aac.hasRightsToList(zimlet, Rights.Admin.R_listZimlet, null)) continue;
                GetZimlet.encodeZimlet(response, zimlet, null, aac.getAttrRightChecker(zimlet));
            }
        } else if ("mail".equalsIgnoreCase(exclude)) {
            for (Zimlet zimlet : zimlets) {
                if (!zimlet.isExtension() || !aac.hasRightsToList(zimlet, Rights.Admin.R_listZimlet, null)) continue;
                GetZimlet.encodeZimlet(response, zimlet, null, aac.getAttrRightChecker(zimlet));
            }
        } else {
            for (Zimlet zimlet : zimlets) {
                if (!aac.hasRightsToList(zimlet, Rights.Admin.R_listZimlet, null)) continue;
                GetZimlet.encodeZimlet(response, zimlet, null, aac.getAttrRightChecker(zimlet));
            }
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_listZimlet);
        relatedRights.add(Rights.Admin.R_getZimlet);
        notes.add("If the authenticated admin does not have the corresponding list{Entry} right for an entry, the entry is skipped in the getAllXXX/searchXXX/searchDirectoryResponse,  no PERM_DENIED exception will be thrown. Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.");
    }
}

