/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.service.admin.RightDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAllRights
extends RightDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext lc = GetAllRights.getZimbraSoapContext(context);
        String targetType = request.getAttribute("targetType", null);
        boolean expandAllAtrts = request.getAttributeBool("expandAllAttrs", false);
        List<Right> rights = RightCommand.getAllRights(targetType);
        Element response = lc.createElement(AdminConstants.GET_ALL_RIGHTS_RESPONSE);
        for (Right right : rights) {
            RightCommand.rightToXML(response, right, expandAllAtrts);
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Do not need any right, all admins are allowed.");
    }
}

