/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.session.AdminSession;
import com.zimbra.cs.session.Session;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAllMailboxes
extends AdminDocumentHandler {
    private static final String GET_ALL_MAILBOXES_CACHE_KEY = "GetAllMailboxes";
    public static final String SORT_TOTAL_USED = "totalUsed";

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        int i;
        List<Mailbox.MailboxData> mailboxes;
        ZimbraSoapContext zsc = GetAllMailboxes.getZimbraSoapContext(context);
        this.checkRight(zsc, context, null, AdminRight.PR_SYSTEM_ADMIN_ONLY);
        int limit = (int)request.getAttributeLong("limit", Integer.MAX_VALUE);
        if (limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        int offset = (int)request.getAttributeLong("offset", 0L);
        MailboxesParams params = new MailboxesParams();
        AdminSession session = (AdminSession)this.getSession(zsc, Session.Type.ADMIN);
        if (session != null) {
            MailboxesParams cachedParams = (MailboxesParams)session.getData(GET_ALL_MAILBOXES_CACHE_KEY);
            if (cachedParams == null || !cachedParams.equals(params)) {
                mailboxes = params.doSearch();
                session.setData(GET_ALL_MAILBOXES_CACHE_KEY, params);
            } else {
                mailboxes = cachedParams.doSearch();
            }
        } else {
            mailboxes = params.doSearch();
        }
        Element response = zsc.createElement(AdminConstants.GET_ALL_MAILBOXES_RESPONSE);
        int limitMax = offset + limit;
        for (i = offset; i < limitMax && i < mailboxes.size(); ++i) {
            Mailbox.MailboxData mailbox = mailboxes.get(i);
            Element mbx = response.addElement("mbox");
            mbx.addAttribute("id", mailbox.id);
            mbx.addAttribute("groupId", mailbox.schemaGroupId);
            mbx.addAttribute("accountId", mailbox.accountId);
            mbx.addAttribute("indexVolumeId", mailbox.indexVolumeId);
            mbx.addAttribute("itemIdCheckPoint", mailbox.lastItemId);
            mbx.addAttribute("contactCount", mailbox.contacts);
            mbx.addAttribute("sizeCheckPoint", mailbox.size);
            mbx.addAttribute("changeCheckPoint", mailbox.lastChangeId);
            mbx.addAttribute("trackingSync", mailbox.trackSync);
            mbx.addAttribute("trackingImap", mailbox.trackImap);
            if (mailbox.lastBackupDate > 0) {
                mbx.addAttribute("lastbackupat", mailbox.lastBackupDate);
            }
            mbx.addAttribute("lastSoapAccess", mailbox.lastWriteDate);
            mbx.addAttribute("newMessages", mailbox.recentMessages);
            mbx.addAttribute("idxDeferredCount", mailbox.idxDeferredCount);
            mbx.addAttribute("highestIndexed", mailbox.highestModContentIndexed.toString());
        }
        response.addAttribute("more", i < mailboxes.size());
        response.addAttribute("searchTotal", mailboxes.size());
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Only system admins are allowed.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MailboxesParams {
        String mSortBy;
        boolean mSortAscending;
        List<Mailbox.MailboxData> mResult;

        MailboxesParams() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof MailboxesParams)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<Mailbox.MailboxData> doSearch() throws ServiceException {
            if (this.mResult != null) {
                return this.mResult;
            }
            List<Mailbox.MailboxData> result = null;
            Object object = DbMailbox.getSynchronizer();
            synchronized (object) {
                DbPool.Connection conn = null;
                try {
                    conn = DbPool.getConnection();
                    result = DbMailbox.getMailboxRawData(conn);
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    DbPool.quietClose(conn);
                    throw throwable;
                }
                DbPool.quietClose(conn);
            }
            this.mResult = result;
            return this.mResult;
        }
    }
}

