/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.fb.FreeBusyProvider;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAllFreeBusyProviders
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetAllFreeBusyProviders.getZimbraSoapContext(context);
        this.checkRight(zsc, context, null, AdminRight.PR_SYSTEM_ADMIN_ONLY);
        Element response = zsc.createElement(AdminConstants.GET_ALL_FREE_BUSY_PROVIDERS_RESPONSE);
        for (FreeBusyProvider prov : FreeBusyProvider.getProviders()) {
            Element provElem = response.addElement("provider");
            provElem.addAttribute("name", prov.getName());
            provElem.addAttribute("propagate", prov.registerForMailboxChanges());
            provElem.addAttribute("start", prov.cachedFreeBusyStartTime());
            provElem.addAttribute("end", prov.cachedFreeBusyEndTime());
            provElem.addAttribute("queue", prov.getQueueFilename());
            provElem.addAttribute("prefix", prov.foreignPrincipalPrefix());
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Only system admins are allowed.");
    }
}

