/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.RightDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAllEffectiveRights
extends RightDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String grantee;
        Provisioning.GranteeBy granteeBy;
        String granteeType;
        ZimbraSoapContext zsc = GetAllEffectiveRights.getZimbraSoapContext(context);
        Pair<Boolean, Boolean> expandAttrs = this.parseExpandAttrs(request);
        boolean expandSetAttrs = expandAttrs.getFirst();
        boolean expandGetAttrs = expandAttrs.getSecond();
        Element eGrantee = request.getOptionalElement("grantee");
        if (eGrantee != null) {
            granteeType = eGrantee.getAttribute("type", GranteeType.GT_USER.getCode());
            granteeBy = Provisioning.GranteeBy.fromString(eGrantee.getAttribute("by"));
            grantee = eGrantee.getText();
        } else {
            granteeType = GranteeType.GT_USER.getCode();
            granteeBy = Provisioning.GranteeBy.id;
            grantee = zsc.getRequestedAccountId();
        }
        GranteeType gt = GranteeType.fromCode(granteeType);
        if (!grantee.equals(zsc.getAuthtokenAccountId())) {
            this.checkCheckRightRight(zsc, gt, granteeBy, grantee);
        }
        RightCommand.AllEffectiveRights aer = RightCommand.getAllEffectiveRights(Provisioning.getInstance(), granteeType, granteeBy, grantee, expandSetAttrs, expandGetAttrs);
        Element resp = zsc.createElement(AdminConstants.GET_ALL_EFFECTIVE_RIGHTS_RESPONSE);
        aer.toXML(resp);
        return resp;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_checkRightUsr);
        relatedRights.add(Rights.Admin.R_checkRightGrp);
        notes.add("If grantee to check for is an account, needs the " + Rights.Admin.R_checkRightUsr.getName() + " right");
        notes.add("If grantee to check for is a group, needs the " + Rights.Admin.R_checkRightGrp.getName() + " right");
    }
}

