/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.GetDomain;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAllDomains
extends AdminDocumentHandler {
    public static final String BY_NAME = "name";
    public static final String BY_ID = "id";

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetAllDomains.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        boolean applyConfig = request.getAttributeBool("applyConfig", true);
        List<Domain> domains = prov.getAllDomains();
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        Element response = zsc.createElement(AdminConstants.GET_ALL_DOMAINS_RESPONSE);
        for (Domain domain : domains) {
            if (!aac.hasRightsToList(domain, Rights.Admin.R_listDomain, null)) continue;
            GetDomain.encodeDomain(response, domain, applyConfig, null, aac.getAttrRightChecker(domain));
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_listDomain);
        relatedRights.add(Rights.Admin.R_getDomain);
        notes.add("If the authenticated admin does not have the corresponding list{Entry} right for an entry, the entry is skipped in the getAllXXX/searchXXX/searchDirectoryResponse,  no PERM_DENIED exception will be thrown. Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.");
    }
}

