/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.GetDistributionList;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAllDistributionLists
extends AdminDocumentHandler {
    public static final String BY_NAME = "name";
    public static final String BY_ID = "id";

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetAllDistributionLists.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element response = null;
        Element d = request.getOptionalElement("domain");
        Domain domain = null;
        if (d != null) {
            String key = d.getAttribute("by");
            String value = d.getText();
            if (key.equals(BY_NAME)) {
                domain = prov.get(Provisioning.DomainBy.name, value);
            } else if (key.equals(BY_ID)) {
                domain = prov.get(Provisioning.DomainBy.id, value);
            } else {
                throw ServiceException.INVALID_REQUEST("unknown value for by: " + key, null);
            }
            if (domain == null) {
                throw AccountServiceException.NO_SUCH_DOMAIN(value);
            }
        }
        if (this.isDomainAdminOnly(zsc)) {
            if (domain != null) {
                this.checkDomainRight(zsc, domain, (Object)AdminRight.PR_ALWAYS_ALLOW);
            }
            domain = this.getAuthTokenAccountDomain(zsc);
        }
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        if (domain != null) {
            response = zsc.createElement(AdminConstants.GET_ALL_DISTRIBUTION_LISTS_RESPONSE);
            this.doDomain(zsc, response, domain, aac);
        } else {
            response = zsc.createElement(AdminConstants.GET_ALL_DISTRIBUTION_LISTS_RESPONSE);
            List<Domain> domains = prov.getAllDomains();
            for (Domain dm : domains) {
                this.doDomain(zsc, response, dm, aac);
            }
        }
        return response;
    }

    private void doDomain(ZimbraSoapContext zsc, Element e, Domain d, AdminAccessControl aac) throws ServiceException {
        List dls = Provisioning.getInstance().getAllDistributionLists(d);
        for (DistributionList dl : dls) {
            if (!aac.hasRightsToList(dl, Rights.Admin.R_listDistributionList, null)) continue;
            GetDistributionList.encodeDistributionList(e, dl, true, null, aac.getAttrRightChecker(dl));
        }
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_listDistributionList);
        relatedRights.add(Rights.Admin.R_getDistributionList);
        notes.add("If the authenticated admin does not have the corresponding list{Entry} right for an entry, the entry is skipped in the getAllXXX/searchXXX/searchDirectoryResponse,  no PERM_DENIED exception will be thrown. Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.");
    }
}

