/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAllConfig
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetAllConfig.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Config config = prov.getConfig();
        AdminAccessControl aac = this.checkRight(zsc, context, config, AdminRight.PR_ALWAYS_ALLOW);
        Element response = zsc.createElement(AdminConstants.GET_ALL_CONFIG_RESPONSE);
        GetAllConfig.encodeConfig(response, config, null, aac.getAttrRightChecker(config));
        return response;
    }

    public static void encodeConfig(Element e, Config config, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) {
        Map<String, Object> attrs = config.getUnicodeAttrs();
        ToXML.encodeAttrs(e, attrs, reqAttrs, attrRightChecker);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getGlobalConfig);
    }
}

