/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.GetAllAccounts;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAllCalendarResources
extends GetAllAccounts {
    @Override
    protected QName getResponseQName() {
        return AdminConstants.GET_ALL_CALENDAR_RESOURCES_RESPONSE;
    }

    @Override
    protected void doDomain(ZimbraSoapContext zsc, Element e, Domain d, Server s) throws ServiceException {
        CalendarResourceVisitor visitor = new CalendarResourceVisitor(zsc, this, e);
        Provisioning.getInstance().getAllCalendarResources(d, s, visitor);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_listCalendarResource);
        relatedRights.add(Rights.Admin.R_getCalendarResource);
        notes.add("If the authenticated admin does not have the corresponding list{Entry} right for an entry, the entry is skipped in the getAllXXX/searchXXX/searchDirectoryResponse,  no PERM_DENIED exception will be thrown. Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.");
    }

    protected static class CalendarResourceVisitor
    extends GetAllAccounts.AccountVisitor {
        CalendarResourceVisitor(ZimbraSoapContext zsc, AdminDocumentHandler handler, Element parent) throws ServiceException {
            super(zsc, handler, parent);
        }

        public void visit(NamedEntry entry) throws ServiceException {
            if (this.mHandler.hasRightsToList(this.mZsc, entry, Rights.Admin.R_listCalendarResource, null)) {
                ToXML.encodeCalendarResource(this.mParent, (CalendarResource)entry, true, null, this.mAAC.getAttrRightChecker(entry));
            }
        }
    }
}

