/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAllAccounts
extends AdminDocumentHandler {
    public static final String BY_NAME = "name";
    public static final String BY_ID = "id";

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Element d;
        ZimbraSoapContext zsc = GetAllAccounts.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element response = null;
        Element s = request.getOptionalElement("server");
        Server server = null;
        if (s != null) {
            String key = s.getAttribute("by");
            String value = s.getText();
            if (key.equals(BY_NAME)) {
                server = prov.get(Provisioning.ServerBy.name, value);
            } else if (key.equals(BY_ID)) {
                server = prov.get(Provisioning.ServerBy.id, value);
            } else {
                throw ServiceException.INVALID_REQUEST("unknown value for server by: " + key, null);
            }
            if (server == null) {
                throw AccountServiceException.NO_SUCH_SERVER(value);
            }
        }
        if ((d = request.getOptionalElement("domain")) != null || this.isDomainAdminOnly(zsc)) {
            String key = d == null ? BY_NAME : d.getAttribute("by");
            String value = d == null ? this.getAuthTokenAccountDomain(zsc).getName() : d.getText();
            Domain domain = null;
            if (key.equals(BY_NAME)) {
                domain = prov.get(Provisioning.DomainBy.name, value);
            } else if (key.equals(BY_ID)) {
                domain = prov.get(Provisioning.DomainBy.id, value);
            } else {
                throw ServiceException.INVALID_REQUEST("unknown value for domain by: " + key, null);
            }
            if (domain == null) {
                throw AccountServiceException.NO_SUCH_DOMAIN(value);
            }
            this.checkDomainRight(zsc, domain, (Object)AdminRight.PR_ALWAYS_ALLOW);
            response = zsc.createElement(this.getResponseQName());
            this.doDomain(zsc, response, domain, server);
        } else {
            response = zsc.createElement(this.getResponseQName());
            List<Domain> domains = prov.getAllDomains();
            if (domains != null) {
                for (Domain domain : domains) {
                    this.doDomain(zsc, response, domain, server);
                }
            } else {
                this.doDomain(zsc, response, null, server);
            }
        }
        return response;
    }

    protected QName getResponseQName() {
        return AdminConstants.GET_ALL_ACCOUNTS_RESPONSE;
    }

    protected void doDomain(ZimbraSoapContext zsc, Element e, Domain d, Server s) throws ServiceException {
        AccountVisitor visitor = new AccountVisitor(zsc, this, e);
        Provisioning.getInstance().getAllAccounts(d, s, visitor);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_listAccount);
        relatedRights.add(Rights.Admin.R_getAccount);
        notes.add("If the authenticated admin does not have the corresponding list{Entry} right for an entry, the entry is skipped in the getAllXXX/searchXXX/searchDirectoryResponse,  no PERM_DENIED exception will be thrown. Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.");
    }

    protected static class AccountVisitor
    implements NamedEntry.Visitor {
        ZimbraSoapContext mZsc;
        AdminDocumentHandler mHandler;
        Element mParent;
        AdminAccessControl mAAC;

        AccountVisitor(ZimbraSoapContext zsc, AdminDocumentHandler handler, Element parent) throws ServiceException {
            this.mZsc = zsc;
            this.mHandler = handler;
            this.mParent = parent;
            this.mAAC = AdminAccessControl.getAdminAccessControl(zsc);
        }

        public void visit(NamedEntry entry) throws ServiceException {
            if (this.mAAC.hasRightsToList(entry, Rights.Admin.R_listAccount, null)) {
                ToXML.encodeAccount(this.mParent, (Account)entry, true, null, this.mAAC.getAttrRightChecker(entry));
            }
        }
    }
}

