/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAdminSavedSearches
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetAdminSavedSearches.getZimbraSoapContext(context);
        Account acct = GetAdminSavedSearches.getRequestedAccount(zsc);
        this.checkAccountRight(zsc, acct, Rights.Admin.R_viewAdminSavedSearch);
        Element response = zsc.createElement(AdminConstants.GET_ADMIN_SAVED_SEARCHES_RESPONSE);
        HashSet<String> specificSearches = null;
        Iterator<Element> it = request.elementIterator("search");
        while (it.hasNext()) {
            Element e;
            String name;
            if (specificSearches == null) {
                specificSearches = new HashSet<String>();
            }
            if ((name = (e = it.next()).getAttribute("name")) == null) continue;
            specificSearches.add(name);
        }
        this.handle(acct, response, specificSearches);
        return response;
    }

    public void handle(Account acct, Element response, HashSet<String> specificSearches) throws ServiceException {
        String[] searches = acct.getMultiAttr("zimbraAdminSavedSearches");
        for (int i = 0; i < searches.length; ++i) {
            String search = searches[i];
            AdminSearch as = AdminSearch.parse(search);
            if (specificSearches != null && !specificSearches.contains(as.getName())) continue;
            response.addElement("search").addAttribute("name", as.getName()).setText(as.getQuery());
        }
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_viewAdminSavedSearch);
    }

    private static void test(String search) {
        AdminSearch as = AdminSearch.parse(search);
        System.out.println("[" + search + "] => [" + as.getName() + "] [" + as.getQuery() + "]");
        String encoded = as.encode();
        assert (search.equals(encoded));
    }

    private static void test(AdminSearch search) {
        String encoded = search.encode();
        System.out.println("[" + search.getName() + "] [" + search.getQuery() + "] => [" + encoded + "]");
        AdminSearch parsed = AdminSearch.parse(encoded);
        String encoded2 = parsed.encode();
        assert (encoded.equals(encoded2));
    }

    public static void main(String[] args) {
        GetAdminSavedSearches.test("name : query");
        GetAdminSavedSearches.test("n a m e : q u e r y");
        GetAdminSavedSearches.test("name\\:\\ : que : ry");
        GetAdminSavedSearches.test("name \\: : query");
        GetAdminSavedSearches.test("\\: : query");
        GetAdminSavedSearches.test(new AdminSearch("name :::", ":::query"));
        GetAdminSavedSearches.test(new AdminSearch("\\:", " \\:::query"));
    }

    public static class AdminSearch {
        private static final String DELIM = " : ";
        private static final int DELIM_LEN = " : ".length();
        String mName = "";
        String mQuery = "";

        public AdminSearch(String name, String query) {
            if (name != null) {
                this.mName = name;
            }
            if (query != null) {
                this.mQuery = query;
            }
        }

        public String getName() {
            return this.mName;
        }

        public String getQuery() {
            return this.mQuery;
        }

        public static AdminSearch parse(String search) {
            String name = null;
            String query = null;
            int delimAt = search.indexOf(DELIM);
            if (delimAt == -1) {
                query = search;
            } else {
                name = search.substring(0, delimAt);
                if (search.length() > delimAt + DELIM_LEN) {
                    query = search.substring(delimAt + DELIM_LEN);
                }
            }
            if (name != null) {
                name = name.replaceAll("\\\\:", ":");
            }
            return new AdminSearch(name, query);
        }

        public String encode() {
            return this.mName.replaceAll(":", "\\\\:") + DELIM + this.mQuery;
        }
    }
}

