/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAdminConsoleUIComp
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        DistributionList dl;
        Provisioning.AclGroups aclGroups;
        String key;
        Enum by;
        ZimbraSoapContext zsc = GetAdminConsoleUIComp.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element resp = zsc.createElement(AdminConstants.GET_ADMIN_CONSOLE_UI_COMP_RESPONSE);
        Element eAccount = request.getOptionalElement("account");
        Element eDL = request.getOptionalElement("dl");
        if (eAccount != null && eDL != null) {
            throw ServiceException.INVALID_REQUEST("can only specify eith account or dl", null);
        }
        Account authedAcct = GetAdminConsoleUIComp.getAuthenticatedAccount(zsc);
        HashSet<String> added = new HashSet<String>();
        if (eAccount != null) {
            by = Provisioning.AccountBy.fromString(eAccount.getAttribute("by"));
            Account acct = prov.get((Provisioning.AccountBy)by, key = eAccount.getText());
            if (acct == null) {
                throw AccountServiceException.NO_SUCH_ACCOUNT(key);
            }
            if (!authedAcct.getId().equals(acct.getId())) {
                this.checkRight(zsc, context, acct, Rights.Admin.R_viewAccountAdminUI);
            }
            this.addValues(acct, resp, added, false);
            aclGroups = prov.getAclGroups(acct, true);
        } else if (eDL != null) {
            by = Provisioning.DistributionListBy.fromString(eDL.getAttribute("by"));
            dl = prov.getAclGroup((Provisioning.DistributionListBy)by, key = eDL.getText());
            if (dl == null) {
                throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(key);
            }
            this.checkRight(zsc, context, dl, Rights.Admin.R_viewDistributionListAdminUI);
            this.addValues(dl, resp, added, false);
            aclGroups = prov.getAclGroups(dl, true);
        } else {
            this.addValues(authedAcct, resp, added, false);
            aclGroups = prov.getAclGroups(authedAcct, true);
        }
        for (String groupId : aclGroups.groupIds()) {
            dl = prov.get(Provisioning.DistributionListBy.id, groupId);
            this.addValues(dl, resp, added, true);
        }
        return resp;
    }

    private void addValues(NamedEntry entry, Element resp, Set<String> added, boolean inherited) {
        Set<String> values = entry.getMultiAttrSet("zimbraAdminConsoleUIComponents");
        for (String value : values) {
            if (added.contains(value)) continue;
            resp.addElement("a").setText(value).addAttribute("inherited", inherited);
            added.add(value);
        }
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_viewAccountAdminUI);
        relatedRights.add(Rights.Admin.R_viewDistributionListAdminUI);
        notes.add("If account/dl is not specified, Do not need any right, all admins are allowed.");
        notes.add("If an account is specified, need the " + Rights.Admin.R_viewAccountAdminUI.getName() + " right.");
        notes.add("If a dl is specified, need the " + Rights.Admin.R_viewDistributionListAdminUI.getName() + " right.");
        notes.add("Note, this call does not check for the get attr right for zimbraAdminConsoleUIComponents attribute on the account/dl, nor on the admin groups they belong.  It simply checks the " + Rights.Admin.R_viewAccountAdminUI.getName() + " or " + Rights.Admin.R_viewDistributionListAdminUI.getName() + " right.");
    }
}

