/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAccountMembership
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetAccountMembership.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element a = request.getElement("account");
        String key = a.getAttribute("by");
        String value = a.getText();
        Account account = prov.get(Provisioning.AccountBy.fromString(key), value, zsc.getAuthToken());
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(value);
        }
        this.checkAccountRight(zsc, account, Rights.Admin.R_getAccountMembership);
        HashMap<String, String> via = new HashMap<String, String>();
        List<DistributionList> lists = prov.getDistributionLists(account, false, via);
        Element response = zsc.createElement(AdminConstants.GET_ACCOUNT_MEMBERSHIP_RESPONSE);
        for (DistributionList dl : lists) {
            Element distributionList = response.addElement("dl");
            distributionList.addAttribute("name", dl.getName());
            distributionList.addAttribute("id", dl.getId());
            String viaDl = via.get(dl.getName());
            if (viaDl != null) {
                distributionList.addAttribute("via", viaDl);
            }
            try {
                this.checkDistributionListRight(zsc, dl, this.needGetAttrsRight());
                String isAdminGroup = dl.getAttr("zimbraIsAdminGroup");
                if (isAdminGroup == null) continue;
                distributionList.addElement("a").addAttribute("n", "zimbraIsAdminGroup").setText(isAdminGroup);
            }
            catch (ServiceException e) {
                if (!"service.PERM_DENIED".equals(e.getCode())) continue;
                ZimbraLog.acl.warn("no permission to view zimbraIsAdminGroup of dl " + dl.getName());
            }
        }
        return response;
    }

    private Set<String> needGetAttrsRight() {
        HashSet<String> attrsNeeded = new HashSet<String>();
        attrsNeeded.add("zimbraIsAdminGroup");
        return attrsNeeded;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getAccountMembership);
        notes.add("If the authed admin has get attr right on  distribution list attr zimbraIsAdminGroup, it is returned in the response if set.");
    }
}

