/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAccountInfo
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetAccountInfo.getZimbraSoapContext(context);
        Element a = request.getElement("account");
        String key = a.getAttribute("by");
        String value = a.getText();
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.fromString(key), value, zsc.getAuthToken());
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(value);
        }
        this.checkAccountRight(zsc, account, Rights.Admin.R_getAccountInfo);
        Element response = zsc.createElement(AdminConstants.GET_ACCOUNT_INFO_RESPONSE);
        response.addElement("name").setText(account.getName());
        GetAccountInfo.addAttr(response, "zimbraId", account.getId());
        GetAccountInfo.addAttr(response, "zimbraMailHost", account.getAttr("zimbraMailHost"));
        GetAccountInfo.doCos(account, response);
        GetAccountInfo.addUrls(response, account);
        return response;
    }

    static void addUrls(Element response, Account account) throws ServiceException {
        String webMailUrl;
        String adminUrl;
        Server server = Provisioning.getInstance().getServer(account);
        if (server == null) {
            return;
        }
        String hostname = server.getAttr("zimbraServiceHostname");
        if (hostname == null) {
            return;
        }
        String http = URLUtil.getSoapURL(server, false);
        String https = URLUtil.getSoapURL(server, true);
        if (http != null) {
            response.addElement("soapURL").setText(http);
        }
        if (https != null && !https.equalsIgnoreCase(http)) {
            response.addElement("soapURL").setText(https);
        }
        if ((adminUrl = URLUtil.getAdminURL(server)) != null) {
            response.addElement("adminSoapURL").setText(adminUrl);
        }
        if ((webMailUrl = URLUtil.getPublicURLForDomain(server, Provisioning.getInstance().getDomain(account), "", true)) != null) {
            response.addElement("publicMailURL").setText(webMailUrl);
        }
    }

    private static void addAttr(Element response, String name, String value) {
        if (value != null && !value.equals("")) {
            Element e = response.addElement("a");
            e.addAttribute("n", name);
            e.setText(value);
        }
    }

    static void doCos(Account acct, Element response) throws ServiceException {
        Cos cos = Provisioning.getInstance().getCOS(acct);
        if (cos != null) {
            Element eCos = response.addUniqueElement("cos");
            eCos.addAttribute("id", cos.getId());
            eCos.addAttribute("name", cos.getName());
        }
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getAccountInfo);
    }
}

