/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.CacheExtension;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.util.SkinUtil;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlushCache
extends AdminDocumentHandler {
    public static final String FLUSH_CACHE = "flushCache";

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String[] types;
        ZimbraSoapContext zsc = FlushCache.getZimbraSoapContext(context);
        Server localServer = Provisioning.getInstance().getLocalServer();
        this.checkRight(zsc, context, localServer, Rights.Admin.R_flushCache);
        Element eCache = request.getElement("cache");
        String typeStr = eCache.getAttribute("type");
        for (String type : types = typeStr.split(",")) {
            Provisioning.CacheEntryType cacheType = null;
            try {
                cacheType = Provisioning.CacheEntryType.fromString(type);
                this.doFlush(context, cacheType, eCache);
            }
            catch (ServiceException e) {
                CacheExtension ce = CacheExtension.getHandler(type);
                if (ce != null) {
                    ce.flushCache();
                    continue;
                }
                throw ServiceException.INVALID_REQUEST("invalid cache type " + type, null);
            }
        }
        Element response = zsc.createElement(AdminConstants.FLUSH_CACHE_RESPONSE);
        return response;
    }

    private void doFlush(Map<String, Object> context, Provisioning.CacheEntryType cacheType, Element eCache) throws ServiceException {
        switch (cacheType) {
            case skin: {
                SkinUtil.flushSkinCache();
                FlushCache.sendFlushRequest(context, "/zimbra", "/js/skin.js");
                break;
            }
            case locale: {
                L10nUtil.flushLocaleCache();
                break;
            }
            case license: {
                this.flushLdapCache(Provisioning.CacheEntryType.config, eCache);
                LdapProvisioning.refreshValidators();
                break;
            }
            case zimlet: {
                FlushCache.sendFlushRequest(context, "/service", "/zimlet/res/all.js");
            }
            default: {
                this.flushLdapCache(cacheType, eCache);
            }
        }
    }

    private void flushLdapCache(Provisioning.CacheEntryType cacheType, Element eCache) throws ServiceException {
        List<Element> eEntries = eCache.listElements("entry");
        Provisioning.CacheEntry[] entries = null;
        if (eEntries.size() > 0) {
            entries = new Provisioning.CacheEntry[eEntries.size()];
            int i = 0;
            for (Element eEntry : eEntries) {
                entries[i++] = new Provisioning.CacheEntry(Provisioning.CacheEntryBy.valueOf(eEntry.getAttribute("by")), eEntry.getText());
            }
        }
        Provisioning.getInstance().flushCache(cacheType, entries);
    }

    static void sendFlushRequest(Map<String, Object> context, String appContext, String resourceUri) throws ServiceException {
        block7: {
            ServletContext containerContext = (ServletContext)context.get("servlet.context");
            if (containerContext == null) {
                if (ZimbraLog.misc.isDebugEnabled()) {
                    ZimbraLog.misc.debug("flushCache: no container context");
                }
                return;
            }
            ServletContext webappContext = containerContext.getContext(appContext);
            RequestDispatcher dispatcher = webappContext.getRequestDispatcher(resourceUri);
            if (dispatcher == null) {
                if (ZimbraLog.misc.isDebugEnabled()) {
                    ZimbraLog.misc.debug("flushCache: no dispatcher for " + resourceUri);
                }
                return;
            }
            try {
                if (ZimbraLog.misc.isDebugEnabled()) {
                    ZimbraLog.misc.debug("flushCache: sending flush request");
                }
                ServletRequest request = (ServletRequest)context.get("servlet.request");
                request.setAttribute(FLUSH_CACHE, (Object)Boolean.TRUE);
                ServletResponse response = (ServletResponse)context.get("servlet.response");
                dispatcher.include(request, response);
            }
            catch (Throwable t) {
                if (!ZimbraLog.misc.isDebugEnabled()) break block7;
                ZimbraLog.misc.debug("flushCache: " + t.getMessage());
            }
        }
    }

    public static void flushChacheOnServer(Server server, ZimbraSoapContext zsc, String cacheType) throws ServiceException, IOException {
        String adminUrl = URLUtil.getAdminURL(server, "/service/admin/soap/");
        SoapHttpTransport mTransport = new SoapHttpTransport(adminUrl);
        mTransport.setAuthToken(zsc.getRawAuthToken());
        Element.XMLElement req = new Element.XMLElement(AdminConstants.FLUSH_CACHE_REQUEST);
        req.addElement("cache").addAttribute("type", cacheType);
        mTransport.invoke(req);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_flushCache);
    }
}

