/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.calendar.tzfixup.TimeZoneFixupRules;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixCalendarTZ
extends AdminDocumentHandler {
    public static final String ALL = "all";
    private static final long DEFAULT_FIXUP_AFTER = 1199098800000L;

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = FixCalendarTZ.getZimbraSoapContext(context);
        this.checkRight(zsc, context, null, AdminRight.PR_SYSTEM_ADMIN_ONLY);
        boolean sync = request.getAttributeBool("sync", false);
        long after = request.getAttributeLong("after", 1199098800000L);
        List<Element> acctElems = request.listElements("account");
        Element tzfixupElem = request.getElement("tzfixup");
        TimeZoneFixupRules tzfixupRules = new TimeZoneFixupRules(tzfixupElem);
        List<String> acctNames = this.parseAccountNames(acctElems);
        if (acctNames.isEmpty()) {
            throw ServiceException.INVALID_REQUEST("Accounts must be specified", null);
        }
        if (sync) {
            FixCalendarTZ.fixAccounts(acctNames, after, tzfixupRules);
        } else {
            CalendarTimeZoneFixupThread thread = new CalendarTimeZoneFixupThread(acctNames, after, tzfixupRules);
            thread.start();
        }
        Element response = zsc.createElement(AdminConstants.FIX_CALENDAR_TZ_RESPONSE);
        return response;
    }

    protected List<String> parseAccountNames(List<Element> acctElems) throws ServiceException {
        ArrayList<String> a = new ArrayList<String>(acctElems.size());
        for (Element elem : acctElems) {
            String name = elem.getAttribute("name");
            if (ALL.equals(name)) {
                ArrayList<String> all = new ArrayList<String>(1);
                all.add(ALL);
                return all;
            }
            String[] parts = name.split("@");
            if (parts.length != 2) {
                throw ServiceException.INVALID_REQUEST("invalid account email address: " + name, null);
            }
            a.add(name);
        }
        return a;
    }

    private static List<NamedEntry> getAccountsOnServer() throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        String serverName = prov.getLocalServer().getAttr("zimbraServiceHostname");
        List<NamedEntry> accts = prov.searchAccounts("(zimbraMailHost=" + serverName + ")", new String[]{"zimbraId"}, null, false, 9);
        ZimbraLog.calendar.info("Found " + accts.size() + " accounts on server " + serverName);
        return accts;
    }

    private static void fixAccounts(List<String> acctNames, long after, TimeZoneFixupRules tzfixupRules) throws ServiceException {
        List<NamedEntry> accts;
        int numAccts = acctNames.size();
        boolean all = numAccts == 1 && ALL.equals(acctNames.get(0));
        int numFixedAccts = 0;
        int numFixedAppts = 0;
        if (all) {
            accts = FixCalendarTZ.getAccountsOnServer();
        } else {
            accts = new ArrayList<NamedEntry>(acctNames.size());
            for (String name : acctNames) {
                try {
                    accts.add(Provisioning.getInstance().get(Provisioning.AccountBy.name, name));
                }
                catch (ServiceException e) {
                    ZimbraLog.calendar.error((Object)("Error looking up account " + name + ": " + e.getMessage()), e);
                }
            }
        }
        numAccts = accts.size();
        int every = 10;
        for (NamedEntry entry : accts) {
            if (!(entry instanceof Account)) continue;
            Account acct = (Account)entry;
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(acct);
            try {
                numFixedAppts += mbox.fixAllCalendarItemTZ(null, after, tzfixupRules);
            }
            catch (ServiceException e) {
                ZimbraLog.calendar.error((Object)("Error fixing timezones in mailbox " + mbox.getId() + ": " + e.getMessage()), e);
            }
            if (++numFixedAccts % every != 0) continue;
            ZimbraLog.calendar.info("Progress: fixed calendar timezones in " + numFixedAccts + "/" + numAccts + " accounts");
        }
        ZimbraLog.calendar.info("Fixed timezones in total " + numFixedAppts + " calendar items in " + numFixedAccts + " accounts");
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Only system admins are allowed.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CalendarTimeZoneFixupThread
    extends Thread {
        private List<String> mAcctNames;
        private long mAfter;
        private TimeZoneFixupRules mFixupRules;

        public CalendarTimeZoneFixupThread(List<String> acctNames, long after, TimeZoneFixupRules tzfixupRules) {
            this.setName("CalendarTimeZoneFixupThread");
            this.mAcctNames = acctNames;
            this.mAfter = after;
            this.mFixupRules = tzfixupRules;
        }

        @Override
        public void run() {
            try {
                FixCalendarTZ.fixAccounts(this.mAcctNames, this.mAfter, this.mFixupRules);
            }
            catch (ServiceException e) {
                ZimbraLog.calendar.error((Object)("Error while fixing up calendar timezones: " + e.getMessage()), e);
            }
        }
    }
}

