/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.db.DbBlobConsistency;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportAndDeleteItems
extends AdminDocumentHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = ExportAndDeleteItems.getZimbraSoapContext(context);
        this.checkRight(zsc, context, null, AdminRight.PR_SYSTEM_ADMIN_ONLY);
        Element mboxEl = request.getElement("mbox");
        long mboxId = mboxEl.getAttributeLong("id");
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        ArrayList<Integer> itemIds = new ArrayList<Integer>();
        for (Element itemEl : mboxEl.listElements("item")) {
            itemIds.add((int)itemEl.getAttributeLong("id"));
        }
        String dirPath = request.getAttribute("exportDir", null);
        String prefix = request.getAttribute("exportFilenamePrefix", null);
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            if (dirPath != null) {
                File exportDir = new File(dirPath);
                if (!exportDir.isDirectory()) {
                    throw ServiceException.INVALID_REQUEST(dirPath + " is not a directory", null);
                }
                DbPool.Connection conn = null;
                try {
                    conn = DbPool.getConnection();
                    String filePath = this.makePath(dirPath, "mail_item", prefix);
                    this.export(conn, mbox, "mail_item", "id", itemIds, filePath);
                    filePath = this.makePath(dirPath, "revision", prefix);
                    this.export(conn, mbox, "revision", "item_id", itemIds, filePath);
                    filePath = this.makePath(dirPath, "appointment", prefix);
                    this.export(conn, mbox, "appointment", "item_id", itemIds, filePath);
                    Object var16_15 = null;
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    DbPool.quietClose(conn);
                    throw throwable;
                }
                DbPool.quietClose(conn);
                {
                }
            }
            int[] idArray = new int[itemIds.size()];
            for (int i = 0; i < itemIds.size(); ++i) {
                idArray[i] = (Integer)itemIds.get(i);
            }
            mbox.delete(null, idArray, (byte)-1, null);
        }
        return zsc.createElement(AdminConstants.EXPORT_AND_DELETE_ITEMS_RESPONSE);
    }

    private void export(DbPool.Connection conn, Mailbox mbox, String tableName, String idColName, Collection<Integer> itemIds, String filePath) throws ServiceException {
        if (DbBlobConsistency.getNumRows(conn, mbox, tableName, idColName, itemIds) > 0) {
            DbBlobConsistency.export(conn, mbox, tableName, idColName, itemIds, filePath);
        }
    }

    String makePath(String dirPath, String tableName, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return dirPath + "/" + prefix + tableName + ".txt";
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Only system admins are allowed.");
    }
}

