/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.session.SessionCache;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpSessions
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = DumpSessions.getZimbraSoapContext(context);
        Server localServer = Provisioning.getInstance().getLocalServer();
        this.checkRight(zsc, context, localServer, Rights.Admin.R_getSessions);
        Element response = zsc.createElement(AdminConstants.DUMP_SESSIONS_RESPONSE);
        boolean includeAccounts = request.getAttributeBool("listSessions", false);
        boolean groupByAccount = request.getAttributeBool("groupByAccount", false);
        int totalActiveSessions = 0;
        Provisioning prov = Provisioning.getInstance();
        for (Session.Type type : Session.Type.values()) {
            Element e;
            if (type == Session.Type.NULL) continue;
            if (!includeAccounts) {
                int[] stats = SessionCache.countActive(type);
                if (stats[1] == 0) continue;
                e = response.addElement(type.name().toLowerCase());
                totalActiveSessions += stats[1];
                e.addAttribute("activeAccounts", stats[0]);
                e.addAttribute("activeSessions", stats[1]);
                continue;
            }
            List<Session> sessions = SessionCache.getActiveSessions(type);
            if (sessions.size() == 0) continue;
            e = response.addElement(type.name().toLowerCase());
            totalActiveSessions += sessions.size();
            e.addAttribute("activeSessions", sessions.size());
            if (sessions.size() == 0) continue;
            if (groupByAccount) {
                HashMap<String, ArrayList<Session>> map = new HashMap<String, ArrayList<Session>>();
                for (Session session : sessions) {
                    ArrayList<Session> list = (ArrayList<Session>)map.get(session.getAuthenticatedAccountId());
                    if (list == null) {
                        list = new ArrayList<Session>();
                        map.put(session.getAuthenticatedAccountId(), list);
                    }
                    list.add(session);
                }
                e.addAttribute("activeAccounts", map.size());
                for (Map.Entry entry : map.entrySet()) {
                    Element acctElt = e.addElement("zid");
                    acctElt.addAttribute("name", DumpSessions.getName(prov, (String)entry.getKey()));
                    acctElt.addAttribute("id", (String)entry.getKey());
                    for (Session s : (List)entry.getValue()) {
                        DumpSessions.encodeSession(acctElt, s, false, prov);
                    }
                }
                continue;
            }
            int[] stats = SessionCache.countActive(type);
            e.addAttribute("activeAccounts", stats[0]);
            for (Session session : sessions) {
                DumpSessions.encodeSession(e, session, true, prov);
            }
        }
        response.addAttribute("activeSessions", totalActiveSessions);
        return response;
    }

    private static String getName(Provisioning prov, String id) {
        try {
            Account acct = prov.get(Provisioning.AccountBy.id, id);
            return acct == null ? id : acct.getName();
        }
        catch (ServiceException e) {
            return id;
        }
    }

    private static void encodeSession(Element parent, Session s, boolean includeAcct, Provisioning prov) {
        Element sElt = parent.addElement("s");
        if (includeAcct) {
            sElt.addAttribute("zid", s.getAuthenticatedAccountId());
            sElt.addAttribute("name", DumpSessions.getName(prov, s.getAuthenticatedAccountId()));
        }
        sElt.addAttribute("sid", s.getSessionId());
        sElt.addAttribute("cd", s.getCreationTime());
        sElt.addAttribute("ld", s.getLastAccessTime());
        s.encodeState(sElt);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getSessions);
    }
}

