/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.FlushCache;
import com.zimbra.cs.zimlet.ZimletFile;
import com.zimbra.cs.zimlet.ZimletUtil;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployZimlet
extends AdminDocumentHandler {
    public static final String sPENDING = "pending";
    public static final String sSUCCEEDED = "succeeded";
    public static final String sFAILED = "failed";
    private LRUMap mProgressMap = new LRUMap(20);

    private void deploy(ZimbraSoapContext lc, String aid, ZAuthToken auth, boolean flushCache) throws ServiceException {
        FileUploadServlet.Upload up = FileUploadServlet.fetchUpload(lc.getAuthtokenAccountId(), aid, lc.getAuthToken());
        if (up == null) {
            throw MailServiceException.NO_SUCH_UPLOAD(aid);
        }
        Progress pr = new Progress(auth != null);
        this.mProgressMap.put((Object)aid, (Object)pr);
        DeployThread action = new DeployThread(up, pr, auth, flushCache);
        new Thread(action).start();
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = DeployZimlet.getZimbraSoapContext(context);
        String action = request.getAttribute("action").toLowerCase();
        Element content = request.getElement("content");
        String aid = content.getAttribute("aid", null);
        Boolean flushCache = request.getAttributeBool("flush", false);
        if (!action.equals("status")) {
            if (action.equals("deployall")) {
                for (Server server : Provisioning.getInstance().getAllServers()) {
                    this.checkRight(zsc, context, server, Rights.Admin.R_deployZimlet);
                }
                this.deploy(zsc, aid, zsc.getRawAuthToken(), flushCache);
                if (flushCache.booleanValue()) {
                    if (ZimbraLog.misc.isDebugEnabled()) {
                        ZimbraLog.misc.debug("DeployZimlet: flushing zimlet cache");
                    }
                    this.checkRight(zsc, context, Provisioning.getInstance().getLocalServer(), Rights.Admin.R_flushCache);
                    FlushCache.sendFlushRequest(context, "/service", "/zimlet/res/all.js");
                }
            } else if (action.equals("deploylocal")) {
                Server localServer = Provisioning.getInstance().getLocalServer();
                this.checkRight(zsc, context, localServer, Rights.Admin.R_deployZimlet);
                this.deploy(zsc, aid, null, false);
                if (flushCache.booleanValue()) {
                    if (ZimbraLog.misc.isDebugEnabled()) {
                        ZimbraLog.misc.debug("DeployZimlet: flushing zimlet cache");
                    }
                    this.checkRight(zsc, context, localServer, Rights.Admin.R_flushCache);
                    FlushCache.sendFlushRequest(context, "/service", "/zimlet/res/all.js");
                }
            } else {
                throw ServiceException.INVALID_REQUEST("invalid action " + action, null);
            }
        }
        Element response = zsc.createElement(AdminConstants.DEPLOY_ZIMLET_RESPONSE);
        Progress progress = (Progress)this.mProgressMap.get((Object)aid);
        if (progress != null) {
            progress.writeResponse(response);
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_deployZimlet);
        notes.add("If deploying on all servers, need the " + Rights.Admin.R_deployZimlet.getName() + " right on all servers or on global grant.  If deploying on local server, need " + "the " + Rights.Admin.R_deployZimlet.getName() + " on the local server.");
    }

    private static class DeployThread
    implements Runnable {
        FileUploadServlet.Upload upload;
        Progress progress;
        ZAuthToken auth;
        boolean flushCache;

        public DeployThread(FileUploadServlet.Upload up, Progress pr, ZAuthToken au, boolean flush) {
            this.upload = up;
            this.progress = pr;
            this.auth = au;
            this.flushCache = flush;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Server s = null;
            try {
                try {
                    s = Provisioning.getInstance().getLocalServer();
                    ZimletUtil.deployZimlet(new ZimletFile(this.upload.getName(), this.upload.getInputStream()), this.progress, this.auth, this.flushCache);
                }
                catch (Exception e) {
                    ZimbraLog.zimlet.info((Object)"deploy", e);
                    if (s != null) {
                        this.progress.markFailed(s);
                    }
                    Object var4_3 = null;
                    FileUploadServlet.deleteUpload(this.upload);
                    return;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                FileUploadServlet.deleteUpload(this.upload);
                throw throwable;
            }
            FileUploadServlet.deleteUpload(this.upload);
        }
    }

    private static class Progress
    implements ZimletUtil.DeployListener {
        private Map<String, String> mStatus = new HashMap<String, String>();

        public Progress(boolean allServers) throws ServiceException {
            Provisioning prov = Provisioning.getInstance();
            if (!allServers) {
                this.mStatus.put(prov.getLocalServer().getName(), DeployZimlet.sPENDING);
                return;
            }
            List<Server> servers = prov.getAllServers();
            for (Server s : servers) {
                boolean hasMailboxService = s.getMultiAttrSet("zimbraServiceEnabled").contains("mailbox");
                if (!hasMailboxService) continue;
                this.mStatus.put(s.getName(), DeployZimlet.sPENDING);
            }
        }

        public void markFinished(Server s) {
            this.mStatus.put(s.getName(), DeployZimlet.sSUCCEEDED);
        }

        public void markFailed(Server s) {
            this.mStatus.put(s.getName(), DeployZimlet.sFAILED);
        }

        public void writeResponse(Element resp) {
            Set<Map.Entry<String, String>> entries = this.mStatus.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                Element progress = resp.addElement("progress");
                progress.addAttribute("server", entry.getKey());
                progress.addAttribute("status", entry.getValue());
            }
        }
    }
}

