/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteZimlet
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Element z;
        String name;
        ZimbraSoapContext zsc = DeleteZimlet.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Zimlet zimlet = prov.getZimlet(name = (z = request.getElement("zimlet")).getAttribute("name"));
        if (zimlet == null) {
            throw AccountServiceException.NO_SUCH_ZIMLET(name);
        }
        this.checkRight(zsc, context, zimlet, Rights.Admin.R_deleteZimlet);
        String id = zimlet.getId();
        prov.deleteZimlet(name);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "DeleteZimlet", "name", name, "id", id}));
        Element response = zsc.createElement(AdminConstants.DELETE_ZIMLET_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_deleteZimlet);
    }
}

