/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.XMPPComponent;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteXMPPComponent
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = DeleteXMPPComponent.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element id = request.getElement("xmppcomponent");
        String byStr = id.getAttribute("by");
        String name = id.getText();
        if (name == null || name.equals("")) {
            throw ServiceException.INVALID_REQUEST("must specify a value for a xmppcomponent", null);
        }
        Provisioning.XMPPComponentBy by = Provisioning.XMPPComponentBy.valueOf(byStr);
        XMPPComponent comp = prov.get(by, name);
        if (comp == null) {
            throw AccountServiceException.NO_SUCH_XMPP_COMPONENT(name);
        }
        this.checkRight(zsc, context, comp, Rights.Admin.R_deleteXMPPComponent);
        prov.deleteXMPPComponent(comp);
        Element response = zsc.createElement(AdminConstants.DELETE_XMPPCOMPONENT_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_deleteXMPPComponent);
    }
}

