/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteServer
extends AdminDocumentHandler {
    private static final String[] TARGET_SERVER_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedServerPath() {
        return TARGET_SERVER_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String id;
        ZimbraSoapContext zsc = DeleteServer.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Server server = prov.get(Provisioning.ServerBy.id, id = request.getAttribute("id"));
        if (server == null) {
            throw AccountServiceException.NO_SUCH_SERVER(id);
        }
        this.checkRight(zsc, context, server, Rights.Admin.R_deleteServer);
        prov.deleteServer(server.getId());
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "DeleteServer", "name", server.getName(), "id", server.getId()}));
        Element response = zsc.createElement(AdminConstants.DELETE_SERVER_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_deleteServer);
    }
}

