/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteMailbox
extends AdminDocumentHandler {
    private static final String[] TARGET_ACCOUNT_PATH = new String[]{"mbox", "id"};

    @Override
    protected String[] getProxiedAccountPath() {
        return TARGET_ACCOUNT_PATH;
    }

    @Override
    public boolean domainAuthSufficient(Map<String, Object> context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = DeleteMailbox.getZimbraSoapContext(context);
        Element mreq = request.getElement("mbox");
        String accountId = mreq.getAttribute("id");
        Account account = Provisioning.getInstance().get(Provisioning.AccountBy.id, accountId, zsc.getAuthToken());
        if (account == null) {
            if (this.isDomainAdminOnly(zsc)) {
                throw ServiceException.PERM_DENIED("account doesn't exist, unable to determine authorization");
            }
            this.checkRight(zsc, context, null, Rights.Admin.R_deleteAccount);
            ZimbraLog.account.warn("DeleteMailbox: account doesn't exist: " + accountId + " (still deleting mailbox)");
        } else {
            this.checkAccountRight(zsc, account, Rights.Admin.R_deleteAccount);
        }
        if (account != null) {
            IMPersona.deleteIMPersona(account.getName());
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(accountId, false);
        long mailboxId = -1L;
        if (mbox != null) {
            mailboxId = mbox.getId();
            mbox.deleteMailbox();
        }
        String idString = mbox == null ? "<no mailbox for account " + accountId + ">" : Long.toString(mailboxId);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "DeleteMailbox", "id", idString}));
        Element response = zsc.createElement(AdminConstants.DELETE_MAILBOX_RESPONSE);
        if (mbox != null) {
            response.addElement("mbox").addAttribute("mbxid", mailboxId);
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_deleteAccount);
    }
}

