/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteGalSyncAccount
extends AdminDocumentHandler {
    @Override
    public boolean domainAuthSufficient(Map<String, Object> context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = DeleteGalSyncAccount.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element acctElem = request.getElement("account");
        String acctKey = acctElem.getAttribute("by");
        String acctValue = acctElem.getText();
        Account account = prov.get(Provisioning.AccountBy.fromString(acctKey), acctValue);
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(acctValue);
        }
        String id = account.getId();
        HashSet acctIds = new HashSet();
        Domain domain = prov.getDomain(account);
        Collections.addAll(acctIds, domain.getGalAccountId());
        if (!acctIds.contains(id)) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(id);
        }
        acctIds.remove(id);
        HashMap attrs = new HashMap();
        attrs.put("zimbraGalAccountId", acctIds);
        prov.modifyAttrs(domain, attrs);
        prov.deleteAccount(id);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "DeleteGalSyncAccount", "id", id}));
        Element response = zsc.createElement(AdminConstants.DELETE_GAL_SYNC_ACCOUNT_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("TDB");
    }
}

