/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDomain
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String id;
        ZimbraSoapContext zsc = DeleteDomain.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Domain domain = prov.get(Provisioning.DomainBy.id, id = request.getAttribute("id"));
        if (domain == null) {
            throw AccountServiceException.NO_SUCH_DOMAIN(id);
        }
        if (domain.isShutdown()) {
            throw ServiceException.PERM_DENIED("can not access domain, domain is in " + domain.getDomainStatusAsString() + " status");
        }
        this.checkRight(zsc, context, domain, Rights.Admin.R_deleteDomain);
        String name = domain.getName();
        prov.deleteDomain(id);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "DeleteDomain", "name", name, "id", id}));
        Element response = zsc.createElement(AdminConstants.DELETE_DOMAIN_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_deleteDomain);
    }
}

