/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDistributionList
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String id;
        ZimbraSoapContext zsc = DeleteDistributionList.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        DistributionList distributionList = prov.get(Provisioning.DistributionListBy.id, id = request.getAttribute("id"));
        if (distributionList == null) {
            throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(id);
        }
        this.checkDistributionListRight(zsc, distributionList, Rights.Admin.R_deleteDistributionList);
        prov.deleteDistributionList(distributionList.getId());
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "DeleteDistributionList", "name", distributionList.getName(), "id", distributionList.getId()}));
        Element response = zsc.createElement(AdminConstants.DELETE_DISTRIBUTION_LIST_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_deleteDistributionList);
    }
}

