/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDataSource
extends AdminDocumentHandler {
    private static final String[] TARGET_ACCOUNT_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedAccountPath() {
        return TARGET_ACCOUNT_PATH;
    }

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext zsc = DeleteDataSource.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String id = request.getAttribute("id");
        Map<String, Object> attrs = AdminService.getAttrs(request);
        Account account = prov.get(Provisioning.AccountBy.id, id, zsc.getAuthToken());
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(id);
        }
        this.checkAccountRight(zsc, account, Rights.Admin.R_adminLoginAs);
        Element dsEl = request.getElement("dataSource");
        String dsId = dsEl.getAttribute("id");
        Provisioning.getInstance().deleteDataSource(account, dsId);
        DataSourceManager.updateSchedule(account.getId(), dsId);
        Element response = zsc.createElement(AdminConstants.DELETE_DATA_SOURCE_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_adminLoginAs);
    }
}

