/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteCalendarResource
extends AdminDocumentHandler {
    private static final String[] TARGET_RESOURCE_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedResourcePath() {
        return TARGET_RESOURCE_PATH;
    }

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String id;
        ZimbraSoapContext zsc = DeleteCalendarResource.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        CalendarResource resource = prov.get(Provisioning.CalendarResourceBy.id, id = request.getAttribute("id"));
        if (resource == null) {
            throw AccountServiceException.NO_SUCH_CALENDAR_RESOURCE(id);
        }
        this.checkCalendarResourceRight(zsc, resource, Rights.Admin.R_deleteCalendarResource);
        if (!Provisioning.onLocalServer(resource)) {
            throw ServiceException.WRONG_HOST(resource.getAttr("zimbraMailHost"), null);
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(resource);
        prov.deleteCalendarResource(id);
        mbox.deleteMailbox();
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "DeleteCalendarResource", "name", resource.getName(), "id", resource.getId()}));
        Element response = zsc.createElement(AdminConstants.DELETE_CALENDAR_RESOURCE_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_deleteCalendarResource);
    }
}

