/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAccount
extends AdminDocumentHandler {
    private static final String[] TARGET_ACCOUNT_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedAccountPath() {
        return TARGET_ACCOUNT_PATH;
    }

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Mailbox mbox;
        String id;
        ZimbraSoapContext zsc = DeleteAccount.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.id, id = request.getAttribute("id"), zsc.getAuthToken());
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(id);
        }
        this.checkAccountRight(zsc, account, Rights.Admin.R_deleteAccount);
        Provisioning.SearchOptions options = new Provisioning.SearchOptions();
        options.setFlags(16);
        options.setMaxResults(1);
        options.setQuery(String.format("(%s=%s)", "zimbraNotebookAccount", account.getName()));
        List<NamedEntry> domains = prov.searchDirectory(options);
        if (!domains.isEmpty() && domains.get(0) != null) {
            throw ServiceException.INVALID_REQUEST(String.format("Can not delete account %s because it is a domain-level wiki account for domain %s. If you intend to delete the domain, you need to remove the value in zimbraNotebookAccount attribute of the domain before deleting accounts in this account.", account.getName(), domains.get(0).getName()), null);
        }
        Mailbox mailbox = mbox = Provisioning.onLocalServer(account) ? MailboxManager.getInstance().getMailboxByAccount(account, false) : null;
        if (mbox != null) {
            mbox.deleteMailbox();
        }
        IMPersona.deleteIMPersona(account.getName());
        prov.deleteAccount(id);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "DeleteAccount", "name", account.getName(), "id", account.getId()}));
        Element response = zsc.createElement(AdminConstants.DELETE_ACCOUNT_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_deleteAccount);
    }
}

