/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateAuth
extends AdminDocumentHandler {
    private static final long DEFAULT_AUTH_LIFETIME = 3600L;
    public static final String BY_NAME = "name";
    public static final String BY_ID = "id";

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = DelegateAuth.getZimbraSoapContext(context);
        Element a = request.getElement("account");
        String key = a.getAttribute("by");
        String value = a.getText();
        long lifetime = request.getAttributeLong("duration", 3600L) * 1000L;
        Provisioning prov = Provisioning.getInstance();
        Account account = null;
        if (key.equals(BY_NAME)) {
            account = prov.get(Provisioning.AccountBy.name, value, zsc.getAuthToken());
        } else if (key.equals(BY_ID)) {
            account = prov.get(Provisioning.AccountBy.id, value, zsc.getAuthToken());
        } else {
            throw ServiceException.INVALID_REQUEST("unknown value for by: " + key, null);
        }
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(value);
        }
        this.checkAccountRight(zsc, account, Rights.Admin.R_adminLoginAs);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "DelegateAuth", "accountId", account.getId(), "accountName", account.getName()}));
        Element response = zsc.createElement(AdminConstants.DELEGATE_AUTH_RESPONSE);
        long maxLifetime = account.getTimeInterval("zimbraAuthTokenLifetime", 3600000L);
        long expires = System.currentTimeMillis() + Math.min(lifetime, maxLifetime);
        Account adminAcct = prov.get(Provisioning.AccountBy.id, zsc.getAuthtokenAccountId(), zsc.getAuthToken());
        if (adminAcct == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(zsc.getAuthtokenAccountId());
        }
        AuthToken at = AuthProvider.getAuthToken(account, expires, false, adminAcct);
        at.encodeAuthResp(response, true);
        response.addAttribute("lifetime", lifetime, Element.Disposition.CONTENT);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_adminLoginAs);
        notes.add("This right is needed for an delegated admin to login to users mailboxes to view and manage their mailboxes.");
    }
}

