/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.cs.service.admin.GetZimlet;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateZimlet
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext lc = CreateZimlet.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String name = request.getAttribute("name").toLowerCase();
        Map<String, Object> attrs = AdminService.getAttrs(request, true);
        this.checkRight(lc, context, null, Rights.Admin.R_createZimlet);
        this.checkSetAttrsOnCreate(lc, TargetType.zimlet, name, attrs);
        Zimlet zimlet = prov.createZimlet(name, attrs);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "CreateZimlet", "name", name}, attrs));
        Element response = lc.createElement(AdminConstants.CREATE_ZIMLET_RESPONSE);
        GetZimlet.encodeZimlet(response, zimlet);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_createZimlet);
        notes.add(String.format("All attrs provided in the attribute list have to settable by. the authed admin.   You can grant the %s right, which allows setting all attributes on %s, or grant the set attrs right just for the attributes the admin needs to set while creating an entry.", Rights.Admin.R_modifyZimlet.getName(), "zimlet"));
    }
}

