/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.XMPPComponent;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.cs.service.admin.GetXMPPComponent;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateXMPPComponent
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CreateXMPPComponent.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element cEl = request.getElement("xmppcomponent");
        Map<String, Object> attrs = AdminService.getAttrs(cEl);
        Element domainElt = cEl.getElement("domain");
        String byStr = domainElt.getAttribute("by", "id");
        Provisioning.DomainBy domainby = Provisioning.DomainBy.valueOf(byStr);
        Domain domain = Provisioning.getInstance().get(domainby, domainElt.getText());
        Element serverElt = cEl.getElement("server");
        String serverByStr = serverElt.getAttribute("by");
        Server server = prov.get(Provisioning.ServerBy.fromString(serverByStr), serverElt.getText());
        String name = cEl.getAttribute("name");
        if (!name.endsWith(domain.getName())) {
            throw ServiceException.INVALID_REQUEST("Specified component name must be full name, and must be a subdomain of the specified parent", null);
        }
        this.checkRight(zsc, context, null, Rights.Admin.R_createXMPPComponent);
        this.checkSetAttrsOnCreate(zsc, TargetType.xmppcomponent, name, attrs);
        XMPPComponent comp = prov.createXMPPComponent(name, domain, server, attrs);
        Element response = zsc.createElement(AdminConstants.CREATE_XMPPCOMPONENT_RESPONSE);
        GetXMPPComponent.encodeXMPPComponent(response, comp);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_createXMPPComponent);
        notes.add(String.format("All attrs provided in the attribute list have to settable by. the authed admin.   You can grant the %s right, which allows setting all attributes on %s, or grant the set attrs right just for the attributes the admin needs to set while creating an entry.", Rights.Admin.R_modifyXMPPComponent.getName(), "XMPP component"));
    }
}

