/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.GetVolume;
import com.zimbra.cs.store.file.Volume;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateVolume
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext lc = CreateVolume.getZimbraSoapContext(context);
        Server localServer = Provisioning.getInstance().getLocalServer();
        this.checkRight(lc, context, localServer, Rights.Admin.R_manageVolume);
        Element eVol = request.getElement("volume");
        String name = eVol.getAttribute("name");
        String path = eVol.getAttribute("rootpath");
        short type = (short)eVol.getAttributeLong("type");
        boolean compressBlobs = eVol.getAttributeBool("compressBlobs");
        long compressionThreshold = eVol.getAttributeLong("compressionThreshold");
        Volume vol = Volume.create((short)-1, type, name, path, (short)0, (short)0, (short)0, (short)0, compressBlobs, compressionThreshold);
        Element response = lc.createElement(AdminConstants.CREATE_VOLUME_RESPONSE);
        GetVolume.addVolumeElement(response, vol);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_manageVolume);
    }
}

