/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.ZAttrProvisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateGalSyncAccount
extends AdminDocumentHandler {
    private static final Set<String> emptySet = Collections.emptySet();

    @Override
    public boolean domainAuthSufficient(Map<String, Object> context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CreateGalSyncAccount.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String name = request.getAttribute("name");
        String domainStr = request.getAttribute("domain");
        String typeStr = request.getAttribute("type");
        Element acctElem = request.getElement("account");
        String acctKey = acctElem.getAttribute("by");
        String acctValue = acctElem.getText();
        String password = request.getAttribute("password", null);
        String folder = request.getAttribute("folder", null);
        ZAttrProvisioning.GalMode type = ZAttrProvisioning.GalMode.fromString(typeStr);
        Domain domain = prov.getDomainByName(domainStr);
        if (domain == null) {
            throw AccountServiceException.NO_SUCH_DOMAIN(domainStr);
        }
        Account account = null;
        try {
            account = prov.get(Provisioning.AccountBy.fromString(acctKey), acctValue, zsc.getAuthToken());
        }
        catch (ServiceException se) {
            ZimbraLog.gal.warn((Object)"error checking GalSyncAccount", se);
        }
        if (account == null) {
            if (Provisioning.AccountBy.fromString(acctKey) != Provisioning.AccountBy.name) {
                throw AccountServiceException.NO_SUCH_ACCOUNT(acctValue);
            }
            if (type == ZAttrProvisioning.GalMode.zimbra) {
                for (String acctId : domain.getGalAccountId()) {
                    Account acct = prov.getAccountById(acctId);
                    if (acct == null) continue;
                    for (DataSource ds : prov.getAllDataSources(acct)) {
                        if (!ds.getType().equals((Object)DataSource.Type.gal) || ds.getAttr("zimbraGalType").compareTo("zimbra") != 0) continue;
                        throw AccountServiceException.ACCOUNT_EXISTS(acct.getName());
                    }
                }
            }
            this.checkDomainRightByEmail(zsc, acctValue, Rights.Admin.R_createAccount);
            HashMap<String, Object> accountAttrs = new HashMap<String, Object>();
            StringUtil.addToMultiMap(accountAttrs, "zimbraIsSystemResource", "TRUE");
            StringUtil.addToMultiMap(accountAttrs, "zimbraHideInGal", "TRUE");
            this.checkSetAttrsOnCreate(zsc, TargetType.account, acctValue, accountAttrs);
            account = prov.createAccount(acctValue, password, accountAttrs);
        }
        if (!Provisioning.onLocalServer(account)) {
            String host = account.getMailHost();
            Server server = prov.getServerByName(host);
            return this.proxyRequest(request, context, server);
        }
        String acctName = account.getName();
        String acctId = account.getId();
        HashSet<String> galAcctIds = new HashSet<String>();
        galAcctIds.addAll(Arrays.asList(domain.getGalAccountId()));
        if (!galAcctIds.contains(acctId)) {
            galAcctIds.add(acctId);
            domain.setGalAccountId(galAcctIds.toArray(new String[0]));
        }
        if (folder == null) {
            folder = "/Contacts";
        } else if (folder.length() > 0 && folder.charAt(0) != '/') {
            folder = "/" + folder;
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        Folder contactFolder = null;
        try {
            contactFolder = mbox.getFolderByPath(null, folder);
        }
        catch (MailServiceException.NoSuchItemException e) {
            contactFolder = mbox.createFolder(null, folder, (byte)0, (byte)6);
        }
        int folderId = contactFolder.getId();
        mbox.grantAccess(null, folderId, domain.getId(), (byte)4, ACL.stringToRights("r"), null);
        for (DataSource ds : account.getAllDataSources()) {
            if (ds.getFolderId() != folderId) continue;
            throw MailServiceException.ALREADY_EXISTS(ds.getName(), new ServiceException.Argument[0]);
        }
        Map<String, Object> attrs = AdminService.getAttrs(request, true);
        try {
            attrs.put("zimbraGalType", type.name());
            attrs.put("zimbraDataSourceFolderId", "" + folderId);
            if (!attrs.containsKey("zimbraDataSourceEnabled")) {
                attrs.put("zimbraDataSourceEnabled", "TRUE");
            }
            if (!attrs.containsKey("zimbraGalStatus")) {
                attrs.put("zimbraGalStatus", "enabled");
            }
            prov.createDataSource(account, DataSource.Type.gal, name, attrs);
        }
        catch (ServiceException e) {
            ZimbraLog.gal.error((Object)"error creating datasource for GalSyncAccount", e);
            throw e;
        }
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "CreateGalSyncAccount", "name", acctName}));
        Element response = zsc.createElement(AdminConstants.CREATE_GAL_SYNC_ACCOUNT_RESPONSE);
        ToXML.encodeAccount(response, account, false, emptySet, null);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_createAccount);
        notes.add(String.format("All attrs provided in the attribute list have to settable by. the authed admin.   You can grant the %s right, which allows setting all attributes on %s, or grant the set attrs right just for the attributes the admin needs to set while creating an entry.", Rights.Admin.R_modifyAccount.getName(), "account"));
    }
}

