/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.cs.service.admin.GetDistributionList;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDistributionList
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CreateDistributionList.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String name = request.getAttribute("name").toLowerCase();
        Map<String, Object> attrs = AdminService.getAttrs(request, true);
        this.checkDomainRightByEmail(zsc, name, Rights.Admin.R_createDistributionList);
        this.checkSetAttrsOnCreate(zsc, TargetType.dl, name, attrs);
        DistributionList dl = prov.createDistributionList(name, attrs);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "CreateDistributionList", "name", name}, attrs));
        Element response = zsc.createElement(AdminConstants.CREATE_DISTRIBUTION_LIST_RESPONSE);
        GetDistributionList.encodeDistributionList(response, dl);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_createDistributionList);
        notes.add(String.format("All attrs provided in the attribute list have to settable by. the authed admin.   You can grant the %s right, which allows setting all attributes on %s, or grant the set attrs right just for the attributes the admin needs to set while creating an entry.", Rights.Admin.R_modifyDistributionList.getName(), "distribution list"));
    }
}

