/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.cs.service.admin.GetCos;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateCos
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CreateCos.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String name = request.getAttribute("name").toLowerCase();
        Map<String, Object> attrs = AdminService.getAttrs(request, true);
        this.checkRight(zsc, context, null, Rights.Admin.R_createCos);
        this.checkSetAttrsOnCreate(zsc, TargetType.cos, name, attrs);
        Cos cos = prov.createCos(name, attrs);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "CreateCos", "name", name}, attrs));
        Element response = zsc.createElement(AdminConstants.CREATE_COS_RESPONSE);
        GetCos.encodeCos(response, cos);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_createCos);
        notes.add(String.format("All attrs provided in the attribute list have to settable by. the authed admin.   You can grant the %s right, which allows setting all attributes on %s, or grant the set attrs right just for the attributes the admin needs to set while creating an entry.", Rights.Admin.R_modifyCos.getName(), "cos"));
    }
}

