/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.cs.service.admin.ModifyAccount;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateAccount
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CreateAccount.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String name = request.getAttribute("name").toLowerCase();
        String password = request.getAttribute("password", null);
        Map<String, Object> attrs = AdminService.getAttrs(request, true);
        this.checkDomainRightByEmail(zsc, name, Rights.Admin.R_createAccount);
        this.checkSetAttrsOnCreate(zsc, TargetType.account, name, attrs);
        this.checkCos(zsc, attrs);
        Account account = prov.createAccount(name, password, attrs);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "CreateAccount", "name", name}, attrs));
        Element response = zsc.createElement(AdminConstants.CREATE_ACCOUNT_RESPONSE);
        ToXML.encodeAccount(response, account);
        return response;
    }

    private void checkCos(ZimbraSoapContext zsc, Map<String, Object> attrs) throws ServiceException {
        String cosId = ModifyAccount.getStringAttrNewValue("zimbraCOSId", attrs);
        if (cosId == null) {
            return;
        }
        Provisioning prov = Provisioning.getInstance();
        Cos cos = prov.get(Provisioning.CosBy.id, cosId);
        if (cos == null) {
            throw AccountServiceException.NO_SUCH_COS(cosId);
        }
        CreateAccount.checkRight(zsc, cos, Rights.Admin.R_assignCos);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_createAccount);
        notes.add(String.format("All attrs provided in the attribute list have to settable by. the authed admin.   You can grant the %s right, which allows setting all attributes on %s, or grant the set attrs right just for the attributes the admin needs to set while creating an entry.", Rights.Admin.R_modifyAccount.getName(), "account"));
        notes.add("Notes on zimbraCOSId: If setting zimbraCOSId, needs the " + Rights.Admin.R_assignCos.getName() + " right on the cos.");
    }
}

