/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountAccount
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CountAccount.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element d = request.getElement("domain");
        String key = d.getAttribute("by");
        String value = d.getText();
        Domain domain = prov.get(Provisioning.DomainBy.fromString(key), value);
        if (domain == null) {
            throw AccountServiceException.NO_SUCH_DOMAIN(value);
        }
        this.checkDomainRight(zsc, domain, (Object)Rights.Admin.R_countAccount);
        Element response = zsc.createElement(AdminConstants.COUNT_ACCOUNT_RESPONSE);
        Provisioning.CountAccountResult result = Provisioning.getInstance().countAccount(domain);
        this.toXML(response, result);
        return response;
    }

    private void toXML(Element parent, Provisioning.CountAccountResult result) {
        for (Provisioning.CountAccountResult.CountAccountByCos c : result.getCountAccountByCos()) {
            Element eCos = parent.addElement("cos");
            eCos.addAttribute("id", c.getCosId());
            eCos.addAttribute("name", c.getCosName());
            eCos.setText(String.valueOf(c.getCount()));
        }
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_countAccount);
    }
}

