/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.GetCos;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyCos
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext lc = CopyCos.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String destCosName = request.getElement("name").getText().toLowerCase();
        Element srcCosElem = request.getElement("cos");
        String srcCosNameOrId = srcCosElem.getText();
        Provisioning.CosBy srcCosBy = Provisioning.CosBy.fromString(srcCosElem.getAttribute("by"));
        Cos srcCos = prov.get(srcCosBy, srcCosNameOrId);
        if (srcCos == null) {
            throw AccountServiceException.NO_SUCH_COS(srcCosNameOrId);
        }
        this.checkRight(lc, context, null, Rights.Admin.R_createCos);
        this.checkRight(lc, context, srcCos, Rights.Admin.R_getCos);
        Cos cos = prov.copyCos(srcCos.getId(), destCosName);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "CopyCos", "name", destCosName, "cos", srcCosNameOrId}));
        Element response = lc.createElement(AdminConstants.COPY_COS_RESPONSE);
        GetCos.encodeCos(response, cos);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_createCos);
        relatedRights.add(Rights.Admin.R_getCos);
        notes.add("Need the " + Rights.Admin.R_getCos.getName() + " right on the source cos.");
    }
}

