/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.zimlet.ZimletException;
import com.zimbra.cs.zimlet.ZimletUtil;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureZimlet
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        this.checkRightTODO();
        ZimbraSoapContext zsc = ConfigureZimlet.getZimbraSoapContext(context);
        Element content = request.getElement("content");
        String attachment = content.getAttribute("aid", null);
        FileUploadServlet.Upload up = FileUploadServlet.fetchUpload(zsc.getAuthtokenAccountId(), attachment, zsc.getAuthToken());
        if (up == null) {
            throw MailServiceException.NO_SUCH_UPLOAD(attachment);
        }
        Element response = zsc.createElement(AdminConstants.CONFIGURE_ZIMLET_RESPONSE);
        try {
            try {
                byte[] blob = ByteUtil.getContent(up.getInputStream(), 0);
                ZimletUtil.installConfig(new String(blob));
            }
            catch (IOException ioe) {
                throw ServiceException.FAILURE("cannot configure", ioe);
            }
            catch (ZimletException ze) {
                throw ServiceException.FAILURE("cannot configure", ze);
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            FileUploadServlet.deleteUpload(up);
            throw throwable;
        }
        FileUploadServlet.deleteUpload(up);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("TDB");
        notes.add("Currently the soap gets a uploaded blob containing metadata. The zimlet name is encoded in in the blob and is decoded in ZimletUtil. We need a way to know the zimlet name (and cos name if any, currently it seems to always only update the default cos) in the SOAP handler in order to check right.");
    }
}

