/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.mime.ContentDisposition;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.rmgmt.RemoteManager;
import com.zimbra.cs.rmgmt.RemoteResult;
import com.zimbra.cs.servlet.ZimbraServlet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CollectLDAPConfigZimbra
extends ZimbraServlet {
    private static final String DOWNLOAD_CONTENT_TYPE = "application/x-compressed";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            AuthToken authToken = CollectLDAPConfigZimbra.getAdminAuthTokenFromCookie(req, resp);
            if (authToken == null) {
                return;
            }
            Provisioning prov = Provisioning.getInstance();
            String ldapHost = LC.ldap_host.value();
            if (ldapHost == null) {
                throw ServiceException.INVALID_REQUEST("Cannot find value for ldap_host in local config", null);
            }
            Server server = prov.get(Provisioning.ServerBy.name, ldapHost);
            if (server == null) {
                throw ServiceException.INVALID_REQUEST("Cannot find server record for LDAP master host: " + ldapHost, null);
            }
            RemoteManager rmgr = RemoteManager.getRemoteManager(server);
            RemoteResult rr = rmgr.execute("zmcollectldapzimbra");
            resp.setContentType(DOWNLOAD_CONTENT_TYPE);
            ContentDisposition cd = new ContentDisposition("inline").setParameter("filename", ldapHost + ".ldiff.gz");
            resp.addHeader("Content-Disposition", cd.toString());
            ByteUtil.copy(new ByteArrayInputStream(rr.getMStdout()), true, (OutputStream)resp.getOutputStream(), false);
        }
        catch (ServiceException e) {
            this.returnError(resp, e);
            return;
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

