/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.cs.service.admin.RightDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckRight
extends RightDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Map<String, Object> attrs;
        Element eGrantee;
        String granteeType;
        ZimbraSoapContext zsc = CheckRight.getZimbraSoapContext(context);
        Element eTarget = request.getElement("target");
        String targetType = eTarget.getAttribute("type");
        Provisioning.TargetBy targetBy = null;
        String target = null;
        if (TargetType.fromCode(targetType).needsTargetIdentity()) {
            targetBy = Provisioning.TargetBy.fromString(eTarget.getAttribute("by"));
            target = eTarget.getText();
        }
        if (GranteeType.fromCode(granteeType = (eGrantee = request.getElement("grantee")).getAttribute("type", GranteeType.GT_USER.getCode())) != GranteeType.GT_USER) {
            throw ServiceException.INVALID_REQUEST("invalid grantee type " + granteeType, null);
        }
        Provisioning.GranteeBy granteeBy = Provisioning.GranteeBy.fromString(eGrantee.getAttribute("by"));
        String grantee = eGrantee.getText();
        this.checkCheckRightRight(zsc, GranteeType.GT_USER, granteeBy, grantee);
        Element eRight = request.getElement("right");
        String right = eRight.getText();
        boolean deny = eRight.getAttributeBool("deny", false);
        Element eAttrs = request.getOptionalElement("attrs");
        Map<String, Object> map = attrs = eAttrs == null ? null : AdminService.getAttrs(request);
        if (!grantee.equals(zsc.getAuthtokenAccountId())) {
            this.checkCheckRightRight(zsc, GranteeType.GT_USER, granteeBy, grantee);
        }
        AccessManager.ViaGrant via = new AccessManager.ViaGrant();
        boolean result = RightCommand.checkRight(Provisioning.getInstance(), targetType, targetBy, target, granteeBy, grantee, right, attrs, via);
        Element resp = zsc.createElement(AdminConstants.CHECK_RIGHT_RESPONSE);
        resp.addAttribute("allow", result);
        if (via.available()) {
            Element eVia = resp.addElement("via");
            Element eViaTarget = eVia.addElement("target");
            eViaTarget.addAttribute("type", via.getGranteeType());
            eViaTarget.setText(via.getTargetName());
            Element eViaGrantee = eVia.addElement("grantee");
            eViaGrantee.addAttribute("type", via.getGranteeType());
            eViaGrantee.setText(via.getGranteeName());
            Element eViaRight = eVia.addElement("right");
            eViaRight.addAttribute("deny", via.isNegativeGrant());
            eViaRight.setText(via.getRight());
        }
        return resp;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_checkRightUsr);
    }
}

