/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.ldap.Check;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckHostnameResolve
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CheckHostnameResolve.getZimbraSoapContext(context);
        String host = request.getAttribute("hostname").toLowerCase();
        Check.Result r = Check.checkHostnameResolve(host);
        Element response = zsc.createElement(AdminConstants.CHECK_HOSTNAME_RESOLVE_RESPONSE);
        response.addElement("code").addText(r.getCode());
        String message = r.getMessage();
        if (message != null) {
            response.addElement("message").addText(message);
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Do not need any right, all admins are allowed.");
    }
}

