/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.gal.GalOp;
import com.zimbra.cs.account.ldap.Check;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.cs.service.admin.AutoCompleteGal;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckGalConfig
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        List<GalContact> contacts;
        ZimbraSoapContext zsc = CheckGalConfig.getZimbraSoapContext(context);
        this.checkRight(zsc, context, null, Rights.Admin.R_checkExternalGALConfig);
        Element q = request.getOptionalElement("query");
        String query = null;
        long limit = 0L;
        if (q != null) {
            query = q.getText();
            limit = q.getAttributeLong("limit", 10L);
        }
        Element action = request.getOptionalElement("action");
        GalOp galOp = GalOp.search;
        if (action != null) {
            galOp = GalOp.fromString(action.getText());
        }
        Map<String, Object> attrs = AdminService.getAttrs(request, true);
        Element response = zsc.createElement(AdminConstants.CHECK_GAL_CONFIG_RESPONSE);
        Check.Result r = Check.checkGalConfig(attrs, query, (int)limit, galOp);
        response.addElement("code").addText(r.getCode());
        String message = r.getMessage();
        if (message != null) {
            response.addElement("message").addText(message);
        }
        if (r instanceof Check.GalResult && (contacts = ((Check.GalResult)r).getContacts()) != null) {
            for (GalContact contact : contacts) {
                AutoCompleteGal.addContact(response, contact);
            }
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_checkExternalGALConfig);
        notes.add(Rights.Admin.R_checkExternalGALConfig.getName() + " is a domain right.  However CheckExchangeAuth does not take a " + "domain, thus the right has to be granted on the global grant " + "to be effective.");
    }
}

