/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.ldap.Check;
import com.zimbra.cs.fb.ExchangeFreeBusyProvider;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckExchangeAuth
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CheckExchangeAuth.getZimbraSoapContext(context);
        Account authedAcct = CheckExchangeAuth.getAuthenticatedAccount(zsc);
        Domain domain = Provisioning.getInstance().getDomain(authedAcct);
        this.checkRight(zsc, context, domain, Rights.Admin.R_checkExchangeAuthConfig);
        Element auth = request.getElement("auth");
        ExchangeFreeBusyProvider.ServerInfo sinfo = new ExchangeFreeBusyProvider.ServerInfo();
        sinfo.url = auth.getAttribute("url");
        sinfo.authUsername = auth.getAttribute("user");
        sinfo.authPassword = auth.getAttribute("pass");
        String scheme = auth.getAttribute("scheme");
        sinfo.scheme = ExchangeFreeBusyProvider.AuthScheme.valueOf(scheme);
        Check.Result r = Check.checkExchangeAuth(sinfo, authedAcct);
        Element response = zsc.createElement(AdminConstants.CHECK_EXCHANGE_AUTH_RESPONSE);
        response.addElement("code").addText(r.getCode());
        String message = r.getMessage();
        if (message != null) {
            response.addElement("message").addText(message);
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_checkExchangeAuthConfig);
    }
}

