/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckDomainMXRecord
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CheckDomainMXRecord.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element d = request.getElement("domain");
        String key = d.getAttribute("by");
        String value = d.getText();
        Domain domain = prov.get(Provisioning.DomainBy.fromString(key), value);
        this.checkDomainRight(zsc, domain, (Object)Rights.Admin.R_checkDomainMXRecord);
        String SMTPHost = domain.getAttr("zimbraDNSCheckHostname", true);
        String domainName = domain.getName();
        if (SMTPHost == null || SMTPHost.length() < 1) {
            SMTPHost = domain.getAttr("zimbraSmtpHostname", false);
        }
        if (SMTPHost == null || SMTPHost.length() < 1) {
            SMTPHost = prov.getLocalServer().getAttr("zimbraSmtpHostname");
        }
        if (SMTPHost == null || SMTPHost.length() < 1) {
            SMTPHost = prov.getConfig().getAttr("zimbraSmtpHostname");
        }
        if (SMTPHost == null || SMTPHost.length() < 1) {
            SMTPHost = domain.getName();
        }
        String SMTPHostMatch = String.format("^[0-9]{2}\\s%s\\.$", SMTPHost);
        ZimbraLog.soap.info("checking domain mx record");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        String message = String.format("Domain is configured to use SMTP host: %s. None of the MX records match this name.", SMTPHost);
        Element response = zsc.createElement(AdminConstants.CHECK_DOMAIN_MX_RECORD_RESPONSE);
        boolean found = false;
        try {
            InitialDirContext ictx = new InitialDirContext(env);
            Attributes attrs = ictx.getAttributes(domainName, new String[]{"MX"});
            if (attrs.size() < 1) {
                throw ServiceException.FAILURE("NoMXRecordsForDomain", null);
            }
            NamingEnumeration<? extends Attribute> ne = attrs.getAll();
            block3: while (ne.hasMore()) {
                Attribute attr = ne.next();
                if (attr.size() == 1) {
                    String rec;
                    ZimbraLog.soap.info("single attribute");
                    Object o = attr.get();
                    if (o instanceof String) {
                        rec = o.toString();
                        ZimbraLog.soap.info("found MX record " + rec);
                        if (rec.matches(SMTPHostMatch)) {
                            found = true;
                            break;
                        }
                        response.addElement("entry").addText(rec);
                        continue;
                    }
                    rec = new String((byte[])o);
                    ZimbraLog.soap.info("found MX attribute " + attr.getID() + " = " + rec);
                    if (rec.matches(SMTPHostMatch)) {
                        found = true;
                        break;
                    }
                    response.addElement("entry").addText(rec);
                    continue;
                }
                ZimbraLog.soap.info("multivalued attribute");
                for (int i = 0; i < attr.size(); ++i) {
                    String rec;
                    Object o = attr.get(i);
                    if (o instanceof String) {
                        rec = o.toString();
                        ZimbraLog.soap.info("found MX record " + attr.getID() + "-" + Integer.toString(i) + " = " + rec);
                        if (rec.matches(SMTPHostMatch)) {
                            found = true;
                            continue block3;
                        }
                        response.addElement("entry").addText(rec);
                        continue;
                    }
                    rec = new String((byte[])o);
                    ZimbraLog.soap.info("found MX attribute " + attr.getID() + "-" + Integer.toString(i) + " = " + rec);
                    if (rec.matches(SMTPHostMatch)) {
                        found = true;
                        continue block3;
                    }
                    response.addElement("entry").addText(rec);
                }
            }
            if (found) {
                response.addElement("code").addText("Ok");
            } else {
                response.addElement("code").addText("Failed");
                response.addElement("message").addText(message);
            }
        }
        catch (NameNotFoundException e) {
            throw ServiceException.FAILURE("NameNotFoundException", e);
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("Failed to verify domain's MX record. " + e.getMessage(), e);
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_checkDomainMXRecord);
    }
}

