/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckDirectory
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext lc = CheckDirectory.getZimbraSoapContext(context);
        Server localServer = Provisioning.getInstance().getLocalServer();
        this.checkRight(lc, context, localServer, Rights.Admin.R_checkDirectoryOnFileSystem);
        Element response = lc.createElement(AdminConstants.CHECK_DIRECTORY_RESPONSE);
        Iterator<Element> iter = request.elementIterator("directory");
        while (iter.hasNext()) {
            Element dirReq = iter.next();
            String path = dirReq.getAttribute("path");
            boolean create = dirReq.getAttributeBool("create", false);
            File dir = new File(path);
            boolean exists = dir.exists();
            if (!exists && create) {
                dir.mkdirs();
                exists = dir.exists();
            }
            boolean isDirectory = false;
            boolean readable = false;
            boolean writable = false;
            if (exists) {
                isDirectory = dir.isDirectory();
                readable = dir.canRead();
                writable = dir.canWrite();
            }
            Element dirResp = response.addElement("directory");
            dirResp.addAttribute("path", path);
            dirResp.addAttribute("exists", exists);
            dirResp.addAttribute("isDirectory", isDirectory);
            dirResp.addAttribute("readable", readable);
            dirResp.addAttribute("writable", writable);
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_checkDirectoryOnFileSystem);
    }
}

