/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.store.StoreManager;
import com.zimbra.cs.store.file.BlobConsistencyChecker;
import com.zimbra.cs.store.file.FileBlobStore;
import com.zimbra.cs.store.file.Volume;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBlobConsistency
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CheckBlobConsistency.getZimbraSoapContext(context);
        this.checkRight(zsc, context, null, AdminRight.PR_SYSTEM_ADMIN_ONLY);
        StoreManager sm = StoreManager.getInstance();
        if (!(sm instanceof FileBlobStore)) {
            throw ServiceException.INVALID_REQUEST(sm.getClass().getName() + " is not supported", null);
        }
        ArrayList<Short> volumeIds = new ArrayList<Short>();
        List<Element> volumeElementList = request.listElements("volume");
        if (volumeElementList.isEmpty()) {
            List<Volume> volumes = Volume.getByType((short)1);
            volumes.addAll(Volume.getByType((short)2));
            for (Volume vol : volumes) {
                volumeIds.add(vol.getId());
            }
        } else {
            for (Element volumeEl : volumeElementList) {
                short volumeId = (short)volumeEl.getAttributeLong("id");
                Volume vol = Volume.getById(volumeId);
                if (vol.getType() == 10) {
                    throw ServiceException.INVALID_REQUEST("Index volume " + volumeId + " is not supported", null);
                }
                volumeIds.add(volumeId);
            }
        }
        ArrayList<Long> mailboxIds = new ArrayList<Long>();
        List<Element> mboxElementList = request.listElements("mbox");
        if (mboxElementList.isEmpty()) {
            for (long mboxId : MailboxManager.getInstance().getMailboxIds()) {
                mailboxIds.add(mboxId);
            }
        } else {
            for (Element mboxEl : mboxElementList) {
                Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxEl.getAttributeLong("id"));
                mailboxIds.add(mbox.getId());
            }
        }
        boolean checkSize = request.getAttributeBool("checkSize", true);
        Element response = zsc.createElement(AdminConstants.CHECK_BLOB_CONSISTENCY_RESPONSE);
        Iterator i$ = mailboxIds.iterator();
        while (i$.hasNext()) {
            long mboxId;
            BlobConsistencyChecker checker = new BlobConsistencyChecker();
            mboxId = (Long)i$.next();
            BlobConsistencyChecker.Results results = checker.check(volumeIds, mboxId, checkSize);
            if (!results.hasInconsistency()) continue;
            Element mboxEl = response.addElement("mbox").addAttribute("id", mboxId);
            results.toElement(mboxEl);
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Only system admins are allowed.");
    }
}

